/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.general;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageElement;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.juddi.datatype.Description;

public class VWUDDIDescriptionEditDialog
extends VWModalDialog
implements ActionListener,
KeyListener {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCLE = 1;
    public static final int STATUS_HELP = 2;
    protected JTextArea m_descriptionTextArea = new JTextArea();
    protected JComboBox m_languageComboBox = null;
    protected JButton m_okButton = new JButton(VWResource.s_ok);
    protected JButton m_cancelButton = new JButton(VWResource.s_cancel);
    protected JButton m_helpButton = new JButton(VWResource.s_help);
    protected int m_returnStatus = 0;
    protected Frame m_parentFrame = null;
    private Description m_description = null;
    private boolean m_bChanged = false;

    public VWUDDIDescriptionEditDialog(Frame parent, Description desc) {
        super(parent);
        this.setTitle(VWResource.s_edit);
        Dimension dim = VWStringUtils.stringToDimension("445,275");
        if (dim == null) {
            dim = new Dimension(400, 250);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.m_description = desc;
        this.m_parentFrame = parent;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.setLocationRelativeTo(parent);
    }

    public void releaseResources() {
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_languageComboBox != null) {
            this.m_languageComboBox.removeAll();
            this.m_languageComboBox = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton.removeAll();
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(4, 4));
            mainPanel.add((Component)this.createDescriptionPanel(), "Center");
            mainPanel.add((Component)this.createLanguagePanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createDescriptionPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(4, 4));
            mainPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_description)), "First");
            String descText = "";
            if (this.m_description != null) {
                descText = this.m_description.getValue();
            }
            this.m_descriptionTextArea = new JTextArea(descText);
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.addKeyListener(this);
            mainPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createLanguagePanel() {
        JPanel mainPanel = null;
        try {
            VWLanguageElement le;
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(4, 4));
            mainPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_language)), "Before");
            VWLanguageList languageList = new VWLanguageList();
            VWLanguageElement[] elementList = languageList.getLanguageList();
            this.m_languageComboBox = new JComboBox<VWLanguageElement>(elementList);
            String languageCode = this.m_description.getLanguageCode();
            if ((languageCode != null || languageCode.length() > 0) && (le = languageList.find(languageCode, 1)) != null) {
                this.m_languageComboBox.setSelectedItem(le);
            }
            this.m_languageComboBox.addActionListener(this);
            mainPanel.add((Component)this.m_languageComboBox, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private static void fetchLanguageList() {
        String[] list = new String[]{"Arabic", "Albanian", "Bulgarian", "Chinese", "Croatian", "Czech", "Danish", "Dutch", "English", "Estonian", "Finnish", "French", "German", "Greek", "Georgian", "Hungarian", "Hebrew", "Hindi", "Icelandic", "Indonesian", "Irish", "Italia", "Japanese", "Korean", "Kurdish", "Latin", "Latvian", "Lithuanian", "Macedonian", "Malay", "Mongolian", "Nepali", "Norwegian", "Persian", "Polish", "Portuguese", "Romanian", "Russian", "Serbian", "Slovak", "Slovenian", "Spanish", "Swedish", "Thai", "Turkish", "Ukrainian", "Vietnamese"};
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_okButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.m_okButton);
            this.setOKButtonState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public int getReturnStatus() {
        return this.m_returnStatus;
    }

    public Description getDescription() {
        return this.m_description;
    }

    public boolean hasChanged() {
        return this.m_bChanged;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_returnStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_okButton) {
            String descText = this.m_descriptionTextArea.getText();
            this.m_returnStatus = 0;
            if (descText == null || descText.length() == 0) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_noDescription, VWResource.s_errorMessage, 1);
            } else {
                this.m_description.setValue(descText);
            }
            Object item = this.m_languageComboBox.getSelectedItem();
            if (item instanceof VWLanguageElement) {
                VWLanguageElement le = (VWLanguageElement)item;
                this.m_description.setLanguageCode(le.getCode());
            } else if (item instanceof String) {
                this.m_description.setLanguageCode((String)item);
            }
            this.setVisible(false);
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc093.htm");
        } else if (obj == this.m_descriptionTextArea) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        } else if (obj == this.m_languageComboBox) {
            this.m_bChanged = true;
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        this.m_okButton.setEnabled(true);
        this.m_bChanged = true;
    }

    private void setOKButtonState() {
        if (this.m_okButton == null) {
            return;
        }
        boolean bEnable = true;
        String tempString = null;
        if (this.m_descriptionTextArea != null) {
            tempString = this.m_descriptionTextArea.getText();
            if (tempString == null || VWStringUtils.compare(tempString, "") == 0) {
                bEnable = false;
            }
        } else {
            bEnable = false;
        }
        if (this.m_okButton.isEnabled() != bEnable) {
            this.m_okButton.setEnabled(bEnable);
        }
    }
}

